// Szablon klasy do tworzenia listy czonej
// Wzy rwnie s tworzone za pomoc szablonu klasy
#ifndef LINKEDLIST_H
#define LINKEDLIST_H

//*********************************************
// Szablon ListNode suy to tworzenia klasy wza
// listy czonej.
//*********************************************

template <class T>
class ListNode
{
public:
  T value;           // Warto przechowywana w wle
  ListNode<T> *next; // Zmienna wskazujca nastpny wze

  // Konstruktor
  ListNode(T nodeValue)
  {
    value = nodeValue;
    next = nullptr;
  }
};

//*********************************************
// Szablon klasy LinkedList
//*********************************************

template <class T>
class LinkedList
{
private:
  ListNode<T> *head;  // Wskanik nagwka listy

public:
  // Konstruktor
  LinkedList()
  {
    head = nullptr;
  }

  // Destruktor
  ~LinkedList();

  // Operacje na licie
  void appendNode(T);
  void insertNode(T);
  void deleteNode(T);
  void displayList() const;
};


//**************************************************
// Funkcja appendNode() umieszcza na kocu listy wze
// zawierajcy warto podan w argumencie newValue.
//**************************************************

template <class T>
void LinkedList<T>::appendNode(T newValue)
{
  ListNode<T> *newNode;  // Zmienna wskazujca nowy wze
  ListNode<T> *nodePtr;  // Zmienna do przegldania listy

  // Utworzenie nowego wza i zapisanie w nim argumentu newValue
  newNode = new ListNode<T>(newValue);

  // Jeeli lista nie zawiera wzw,
  // jako pierwszy wstawiany jest newNode.
  if (!head)
    head = newNode;
  else  // W przeciwnym razie zmienna newNode umieszczana jest na kocu listy
  {
    // Ustawienie wskanika nodePtr na pocztku listy
    nodePtr = head;

    // Wyszukanie ostatniego wza listy
    while (nodePtr->next)
      nodePtr = nodePtr->next;

    // Wstawienie newNode jako ostatniego wza listy
    nodePtr->next = newNode;
  }
}

//***************************************************
// Funkcja displayList() wywietla wartoci zapisane we wszystkich
// wzach listy wskazywanej przez nagwek head.
//***************************************************

template <class T>
void LinkedList<T>::displayList() const
{
  ListNode<T> *nodePtr; // Zmienna do przegldania listy

  // Ustawienie wskanika nodePtr na pocztku listy
  nodePtr = head;

  // Przegldanie listy dopki
  // nodePtr wskazuje wze
  while (nodePtr)
  {
    // Wywietlenie zawartoci biecego wza
    cout << nodePtr->value << endl;

    // Przejcie do nastpnego wza
    nodePtr = nodePtr->next;
  }
}

//**************************************************
// Funkcja insertNode() wstawiajca nowy wze
// z wartoci podan w argumencie newValue.
//**************************************************

template <class T>
void LinkedList<T>::insertNode(T newValue)
{
  ListNode<T> *newNode;                // Wskanik nowego wza
  ListNode<T> *nodePtr;                // Zmienna do przegldania listy
  ListNode<T> *previousNode = nullptr; // Wskanik poprzedniego wza

  // Utworzenie nowego wza i zapisanie w nim argumentu newValue
  newNode = new ListNode<T>(newValue);

  // Jeeli lista nie zawiera wzw
  // jako pierwszy wstawiany jest newNode
  if (!head)
  {
    head = newNode;
    newNode->next = nullptr;
  }
  else  // W przeciwnym razie zmienna newNode umieszczana jest na kocu listy
  {
    // Ustawienie wskanika nodePtr na pocztku listy
    nodePtr = head;

    // Zainicjowanie zmiennej previousNode wartoci nullptr
    previousNode = nullptr;

    // Pomicie wszystkich wzw zawierajcych warto mniejsz ni newValue
    while (nodePtr != nullptr && nodePtr->value < newValue)
    {
      previousNode = nodePtr;
      nodePtr = nodePtr->next;
    }

    // Jeeli nowy wze ma by pierwszy w licie,
    // zostanie wstawiony przed wszystkimi wzami.
    if (previousNode == nullptr)
    {
      head = newNode;
      newNode->next = nodePtr;
    }
    else // W przeciwnym razie zostanie wstawiony za poprzednim wzem
    {
      previousNode->next = newNode;
      newNode->next = nodePtr;
    }
  }
}

//******************************************************
// Funkcja deleteNode() wyszukuje wze zawierajcy
// warto rwn searchValue. Jeeli wze zostanie znaleziony,
// jest usuwany z listy i pamici.
//******************************************************

template <class T>
void LinkedList<T>::deleteNode(T searchValue)
{
  ListNode<T> *nodePtr;       // Zmienna do przegldania listy
  ListNode<T> *previousNode;  // Zmienna wskazujca poprzedni wze

  // Jeli lista jest pusta, nie rb nic
  if (!head)
    return;

  // Sprawdzenie, czy pierwszy wze to ten waciwy
  if (head->value == searchValue)
  {
    nodePtr = head->next;
    delete head;
    head = nodePtr;
  }
  else
  {
    // Ustawienie wskanika nodePtr na pocztku listy
    nodePtr = head;

    // Pominicie wszystkich wzw, ktrych zmienna value
    // nie jest rwna searchValue.
    while (nodePtr != nullptr && nodePtr->value != searchValue)
    {
      previousNode = nodePtr;
      nodePtr = nodePtr->next;
    }

    // Jeeli nodePtr nie wskazuje koca listy, poprzedni
    // wze jest czony z wzem znajdujcym si za nodePtr,
    // a nastpnie usuwany jest wze nodePtr.
    if (nodePtr)
    {
      previousNode->next = nodePtr->next;
      delete nodePtr;
    }
  }
}

//**************************************************
// Destruktor
// Usuwa wszystkie wzy listy.
//**************************************************

template <class T>
LinkedList<T>::~LinkedList()
{
  ListNode<T> *nodePtr;  // Zmienna do przegldania listy
  ListNode<T> *nextNode; // Zmienna wskazujca nastpny wze

  // Ustawienie wskanika nodePtr na pocztku listy
  nodePtr = head;

  // Dopki nodePtr nie wskazuje koca listy...
  while (nodePtr != nullptr)
  {
    // ...wskanik jest ustawiany na nastpnym wle, ...
    nextNode = nodePtr->next;

    // ...usuwany jest biecy wze, ...
    delete nodePtr;

    // ...zmienna nodePtr jest ustawiana na nastpnym wle.
    nodePtr = nextNode;
  }
}
#endif
